/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CUpDownControl.h,v 1.2 1999/09/17 04:20:48 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CUpDownControl_h	// [
#define Included_CUpDownControl_h

#include "pgpClassesConfig.h"
#include <commctrl.h>

#include "UMath.h"
#include "CWindow.h"

_PGP_BEGIN

// Class CUpDownControl

class CUpDownControl : public CWindow
{
public:
	CUpDownControl() { }
	CUpDownControl(HWND hWnd) : CWindow(hWnd) { }
	virtual ~CUpDownControl() { }

	PGPUInt32	GetAccel(UDACCEL *pAccelArray, PGPUInt32 sizeArray)
	{
		return SendMessage(UDM_GETACCEL, sizeArray, 
			reinterpret_cast<LPARAM>(pAccelArray));
	}

	PGPUInt32	GetBase() const
	{
		return SendMessage(UDM_GETBASE);
	}

	HWND		GetBuddy() const
	{
		return reinterpret_cast<HWND>(SendMessage(UDM_GETBUDDY));
	}

	PGPInt32	GetPos() const
	{
		return SendMessage(UDM_GETPOS);
	}

	void		GetRange(PGPInt16& low, PGPInt16& high) const;

	PGPBoolean	SetAccel(UDACCEL *pAccelArray, PGPUInt32 numElems)
	{
		return static_cast<PGPBoolean>(SendMessage(UDM_SETACCEL, numElems, 
			reinterpret_cast<LPARAM>(pAccelArray)));
	}

	PGPUInt32	SetBase(PGPUInt32 base) const
	{
		return SendMessage(UDM_SETBASE, base);
	}

	HWND		SetBuddy(HWND buddy) const
	{
		return reinterpret_cast<HWND>(SendMessage(UDM_SETBUDDY), 
			reinterpret_cast<WPARAM>(buddy));
	}

	PGPInt32	SetPos(PGPInt16 newPos) const
	{
		return SendMessage(UDM_SETPOS, 0, newPos);
	}

	void		SetRange(PGPInt16 low, PGPInt16 high) const
	{
		SendMessage(UDM_SETRANGE, 0, UMath::MakeDWord(high, low));
	}
};

_PGP_END

#endif	// ] Included_CUpDownControl_h
